#include <iostream>

#include "ImportList.h"

int main(int argc, char *argv[])
{
    unsigned int argindex;
    unsigned int vecindex;
    std::vector<std::string> imports;

    if (argc < 2)
    {
        std::cerr << "usage: " << argv[0] << " <file(s)>" << std::endl;
        return EXIT_FAILURE;
    }

    for (argindex = 1; argindex < (unsigned)argc; argindex++)
    {
        std::cout << "Imports for " << argv[argindex] << ":" << std::endl;

        if (ImportList::GetList(argv[argindex], imports, ImportList::LT_FUNCTIONS))
        {
            for (vecindex = 0; vecindex < imports.size(); vecindex++)
                std::cout << imports[vecindex].c_str() << std::endl;
        }
        else
        {
            std::cerr << "GetImportList() failed" << std::endl;
        }
    }

    return EXIT_SUCCESS;
}
